---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "onEvent", {} )
Global( "onReaction", {} )
---------------------------------------------------------------------------------------------------------------------------
Global( "localization", nil )
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "ShowHideBtn", nil )
Global( "MainPanel", nil )
Global( "SpellsPanel", nil )
Global( "FightPanel", nil )
---------------------------------------------------------------------------------------------------------------------------
Global( "PlayerPanelPrototype", nil )
Global( "SpellPanelPrototype", nil )
Global( "SpellInfoPanelPrototype", nil )
---------------------------------------------------------------------------------------------------------------------------
Global( "PlayerPanelList", {} )
Global( "SpellPanelList", {} )
Global( "SpellInfoPanelList", {} )
---------------------------------------------------------------------------------------------------------------------------
Global( "DPSMeter", {} )
Global( "bCollectData", false )
Global( "ActiveFightName" , "" )
Global( "CurrentCombatantName" , "" )
Global( "CurrentPlayerPanelID" , "" )
Global( "MAXCOMBATANTS", 24 )
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function HideAllPlayerPanel()
	for i = 0, MAXCOMBATANTS do
		PlayerPanelList[ i ]:Hide()
	end
end
--------------------------------------------------------------------------------
function SetValuesToPlayerPanel( index, Fight )
	local PlayerPanel = PlayerPanelList[ index - 1 ]
	local Combatant = Fight:GetCombatantByIndex( index )
	
	if Combatant and Combatant.bCanUpdate then
		PlayerPanel:Show()
		
		local NameTextView = PlayerPanel:GetChildByName( "PlayerInfoTextViewName" )
		local StatsTextView = PlayerPanel:GetChildByName( "PlayerInfoTextViewStats" )
		local PercentageTextView = PlayerPanel:GetChildByName( "PlayerInfoTextViewPercentage" )
		local Bar = PlayerPanel:GetChildByName( "PlayerInfoBar" )
		
		NameTextView.Widget:SetVal( "Index", common.FormatInt( index , "%d" ) )
		NameTextView.Widget:SetVal( "Name", Combatant.Name )		
		
		StatsTextView.Widget:SetVal( "DamageDone", common.FormatFloat( Combatant.DamageAmount, "%f3K5" ) )
		StatsTextView.Widget:SetVal( "DPS", common.FormatFloat( Combatant.DPS, "%f3K5" ) )
		
		PercentageTextView.Widget:SetVal( "Percentage", common.FormatInt( Combatant.DamagePercentage, "%d" ) )
		
		Bar:SetColor( ClassColors[ Combatant.Class ]  )
		
		local Width = 230 * (  Combatant.DamagePercentage / 100  )
		Bar:SetWidth( Width )
	end
	
end
--------------------------------------------------------------------------------
function SetDPSMeterValues()
	
	local Fight = DPSMeter:GetFightByName( ActiveFightName )
	local CombatantCount = Fight:GetCombatantCount()
	local MainPanelHeight = 47 + CombatantCount * 24
	
	HideAllPlayerPanel()
	MainPanel:SetHeight( MainPanelHeight )	
	
	CombatantCount = CombatantCount > MAXCOMBATANTS and MAXCOMBATANTS or CombatantCount
	
	for i = 1, CombatantCount do
		SetValuesToPlayerPanel( i, Fight )
	end
end
---------------------------------------------------------------------------------------------------------------------------
function SetSpellValuesToSpellPanel( CombatantData, index  )
	
	local SpellData = CombatantData:GetSpellByIndex( index )
	local SpellPanel = SpellPanelList[ index ]
	
	if SpellData then
		
		SpellPanel:Show()
		
		local Bar = SpellPanel:GetChildByName( "SpellBar" )
		local TextViewName = SpellPanel:GetChildByName( "SpellTextViewName" )
		local TextViewDamage = SpellPanel:GetChildByName( "SpellTextViewStats" )
		local TextViewPercentage = SpellPanel:GetChildByName( "SpellTextViewPercentage" )
		local BarWidth = 256 * ( SpellData.DamagePercentage / 100 )
		
		Bar:SetColor( DamageTypeColors[ SpellData.DamageType  ] )
		Bar:SetWidth( BarWidth )
		
		TextViewName.Widget:SetVal( "Index", common.FormatFloat( index + 1 , "%d" ) )
		TextViewName.Widget:SetVal( "Name", SpellData.Name )
		TextViewDamage.Widget:SetVal( "DamageDone", common.FormatFloat( SpellData.DamageAmount , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "DPS", common.FormatFloat( SpellData.DPS , "%f3K5" ) )
		TextViewPercentage.Widget:SetVal( "Percentage", common.FormatFloat( SpellData.DamagePercentage , "%d" ) )
		
	end
end
--------------------------------------------------------------------------------
function SetDamageDetails()

	local CurrentCombatantData = DPSMeter:GetFightByName( ActiveFightName ):GetCombatantByName( CurrentCombatantName )
	SpellsPanel:HideAllChild()
	
	if CurrentCombatantData and CurrentCombatantData.bCanUpdate then
		local CloseSpellsPanelBtn = SpellsPanel:GetChildByName( "CloseBtn" )
		local TextViewName = SpellsPanel:GetChildByName( "SpellPlayerNameTextViewName" )
		
		CloseSpellsPanelBtn:Show()
		TextViewName:Show()
		
		if ( CurrentCombatantData ) then
			TextViewName.Widget:SetVal( "Name", CurrentCombatantData.Name )
			for i = 0, 12 do   
				SetSpellValuesToSpellPanel(  CurrentCombatantData, i )
			end
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_CHANGED" ] = function( params )
	--GROUP_MEMBER_STATE_OFFLINE
	--GROUP_MEMBER_STATE_NEAR
	--GROUP_MEMBER_STATE_FAR
	--RAID_MEMBER_STATE_OFFLINE
	--RAID_MEMBER_STATE_NEAR
	--RAID_MEMBER_STATE_FAR
	
	if group.GetMembers() or raid.IsExist() then
		local PartyMembersInfoList = {}
		
		if not raid.IsExist() then
			PartyMembersInfoList = group.GetMembers()
		else
			local RaidGroups = raid.GetMembers()
			local ind = 0
			for i, Group in RaidGroups do
				for i, member in Group do
					PartyMembersInfoList[ ind ] = member
					ind = ind + 1
				end
			end
		end
		
		for i, member in PartyMembersInfoList do
			local Combatant
			for j, Fight in DPSMeter.FightsList do
				 Combatant = Fight:GetCombatantByName( member.name )
			end
			if Combatant == nil then
				DPSMeter:AddNewCombatantByName( member.name )
				DPSMeter:SetCombatantUpdateStatusByName(member.name, false)
			end
		end
		
		if raid.IsExist() then
			for i, Combatant in DPSMeter:GetAllCombatants() do
				local bInvalid = true
				if IsThisStringValue ( Combatant.Name, object.GetName( avatar.GetId() ) ) then
					bInvalid = false
				else
					for j, member in PartyMembersInfoList do
						if IsThisStringValue ( Combatant.Name, member.name) then
							bInvalid = false
						end
					end
				end
				if bInvalid then
					DPSMeter:RemoveCombatantByName( Combatant.Name )
				end
			end
		end
		
		for i, member in PartyMembersInfoList do
			for j, Fight in DPSMeter.FightsList do
				local Combatant
				Combatant = Fight:GetCombatantByName( member.name )
				if Combatant then
					Combatant:UpdateCombatantDataByID( member.id )
					if member.state ~= GROUP_MEMBER_STATE_NEAR then
						DPSMeter:SetCombatantUpdateStatusByName(member.name, false)
					else
						DPSMeter:SetCombatantUpdateStatusByName(member.name, true)
					end
				end
			end
		end
		
	end
	SetDPSMeterValues()
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_RAID_CHANGED" ] = function( params )
	onEvent["EVENT_GROUP_CHANGED"]()
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_APPEARED" ] = function( params )
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_RAID_APPEARED" ] = function( params )
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_DISAPPEARED" ] = function( params )
	DPSMeter:RemoveAllCombatants()
	DPSMeter:AddNewCombatant( avatar.GetId() )
	CurrentCombatantName = object.GetName( avatar.GetId() )
	SetDPSMeterValues()
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_RAID_DISAPPEARED" ] = function( params )
	onEvent["EVENT_GROUP_DISAPPEARED"]()
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_MEMBER_ADDED" ] = function( params )
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_GROUP_MEMBER_REMOVED" ] = function( params )
	DPSMeter:RemoveCombatantByName( params.name )
	SetDPSMeterValues()
end
---------------------------------------------------------------------------------------------------------------------------
onEvent[ "EVENT_SECOND_TIMER" ] = function( params )

	if avatar.IsExist() then
		local PartyMembersInfoList = group.GetMembers()
		if ( PartyMembersInfoList ) then
			for i, member in PartyMembersInfoList do
				for j, Fight in DPSMeter.FightsList do 
					local Combatant
					Combatant = Fight:GetCombatantByName( member.name )
					if Combatant then 
						Combatant:UpdateCombatantDataByID( member.id )
						if  member.state ~= GROUP_MEMBER_STATE_NEAR then 
							DPSMeter:SetCombatantUpdateStatusByName(member.name, false)
						else
							DPSMeter:SetCombatantUpdateStatusByName(member.name, true)
						end
					end
				end
			end
		end
		
		local bCombat = DPSMeter:GetFightByName( ActiveFightName ):IsCombatantsInCombat()
		
		--if ( bCombat == false ) and ( DPSMeter.bCollectData ) then 
		if ( not bCombat ) and ( DPSMeter.bCollectData ) then 
			DPSMeter.bCollectData = false
			DPSMeter:UpdateFightsData()
			SetDPSMeterValues()
			SetDamageDetails()
		end
		
		if ( DPSMeter.bCollectData ) then
			DPSMeter:UpdateFightsTime()
			SetDPSMeterValues()
			SetDamageDetails()
		end
	end
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_UNIT_DAMAGE_RECEIVED" ] = function( params )
	if params then
		DPSMeter:UpdateFightsData( params )
		SetDPSMeterValues()
		SetDamageDetails()
	end
end
--------------------------------------------------------------------------------
onEvent[ "EVENT_AVATAR_CREATED" ] = function( params )
	DPSMeter:AddNewCombatant( avatar.GetId() )
	CurrentCombatantName = object.GetName( avatar.GetId() )
	SetDPSMeterValues()
	SetDamageDetails()
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function SetSpellInfoValuesToSpellInfoPanel( SpellData, index  )

	local SpellInfoData = SpellData.DamageDetailsList[ index + 1 ]
	local SpellInfoPanel = SpellInfoPanelList[ index ]
	
	if (SpellInfoData) and ( SpellInfoData.Count > 0 ) then 
		
		SpellInfoPanel:Show()
		
		local Bar = SpellInfoPanel:GetChildByName( "SpellDetailBar" )
		local TextViewName = SpellInfoPanel:GetChildByName( "SpellDetailTextViewName" )
		local TextViewCount = SpellInfoPanel:GetChildByName( "SpellDetailTextViewCount" )
		local TextViewDamage = SpellInfoPanel:GetChildByName( "SpellDetailTextViewStats" )
		local TextViewPercentage = SpellInfoPanel:GetChildByName( "SpellDetailTextViewPercentage" )
		local BarWidth = 256 * ( SpellInfoData.Percentage / 100 )
		
		Bar:SetColor( HitTypeColors[ SpellInfoData.Name  ] )
		Bar:SetWidth( BarWidth )
		
		local Name = GetTextLocalized( SpellInfoData.Name )
		
		TextViewName.Widget:SetVal( "Name", Name )
		TextViewCount.Widget:SetVal( "Count", common.FormatFloat( SpellInfoData.Count , "%d" ) )
		TextViewDamage.Widget:SetVal( "Min", common.FormatFloat( SpellInfoData.Min , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "Mid", common.FormatFloat( SpellInfoData.Mid , "%f3K5" ) )
		TextViewDamage.Widget:SetVal( "Max", common.FormatFloat( SpellInfoData.Max , "%f3K5" ) )
		TextViewPercentage.Widget:SetVal( "Percentage", common.FormatFloat( SpellInfoData.Percentage , "%d" ) )
		
	end
end
--------------------------------------------------------------------------------
function HideAllSpellInfoPanel()
	for i = 0, 3 do
		SpellInfoPanelList[ i ]:Hide()
	end
end
--------------------------------------------------------------------------------
function GetSpellPanelIndex( reaction )
	--string.len( "SpellPanel" ) + 1 = 11
	local sender = reaction.sender
	return tonumber( string.sub( sender, 11, string.len( sender ) ) ) or -1
end
--------------------------------------------------------------------------------
function GetPlayerPanelIndex( reaction )
	return tonumber( string.sub( reaction.sender, -1 ) ) or -1
end
---------------------------------------------------------------------------------------------------------------------------
onReaction[ "SpellPanelOnPointing" ] = function( reaction )
	
	HideAllSpellInfoPanel()
	local HeaderPanel = SpellsPanel:GetChildByName( "SpellDetailHeaderPanel" )
	
	if reaction.active then 
		local SpellPanelIndex = GetSpellPanelIndex( reaction )
		local CurrentCombatantData = DPSMeter:GetFightByName( ActiveFightName ):GetCombatantByName( CurrentCombatantName )
		
		HeaderPanel:Show()
		
		if ( CurrentCombatantData ) then
			local SpellData = CurrentCombatantData:GetSpellByIndex( SpellPanelIndex )
			for i = 0, 3 do
				SetSpellInfoValuesToSpellInfoPanel( SpellData, i )
			end
		end
	else
		HeaderPanel:Hide()
	end
end
--------------------------------------------------------------------------------
onReaction[ "ResetBtnReaction" ] = function( reaction )
	DPSMeter:ResetAllFights()
	--SetDPSMeterValues()
	onEvent["EVENT_GROUP_DISAPPEARED"]()
	onEvent["EVENT_GROUP_CHANGED"]()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onReaction[ "CloseMainPanelBtnReaction" ] = function( reaction )
	MainPanel:Hide()
	SpellsPanel:Hide()
end
--------------------------------------------------------------------------------
onReaction[ "PlayerPanelOnPointing" ] = function( reaction )
	CurrentPlayerPanelID = reaction.active and GetPlayerPanelIndex( reaction ) or -1
end
--------------------------------------------------------------------------------
onReaction[ "PlayerInfoButtonDown" ] = function( reaction )
	local PlayerIndex = GetPlayerPanelIndex( reaction )
	local CurrentFight = DPSMeter:GetFightByName( ActiveFightName )
	CurrentCombatantName = CurrentFight:GetCombatantNameByIndex( CurrentPlayerPanelID )
	SpellsPanel:Show()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onReaction[ "CloseSpellInfoPanelBtnReaction" ] = function( reaction )
	SpellsPanel:Hide()
end
--------------------------------------------------------------------------------
onReaction[ "GetFightBtnReaction" ] = function( reaction )
	local invertMode = { [ "AllFights" ] = "CurrentFight", [ "CurrentFight" ] = "AllFights" }
	ActiveFightName = invertMode[ ActiveFightName ]
	
	local Name = GetTextLocalized( ActiveFightName )
	local NameTextView = FightPanel:GetChildByName( "FightNameTextView" )
	NameTextView.Widget:SetVal( "Name", Name )
	
	SetDPSMeterValues()
	SetDamageDetails()
end
--------------------------------------------------------------------------------
onReaction[ "ShowHideBtnReaction" ] = function( reaction )
	if MainPanel.Widget:IsVisible() then
		MainPanel:Hide()
		SpellsPanel:Hide()
	else
		MainPanel:Show()
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function Init()
	DNDInit()
	RegisterEventHandlers( onEvent )
	RegisterReactionHandlers( onReaction )
	
	---------------------------------------------------------------------------------------------------------------------------
	
	localization = GetGameLocalization()
	
	---------------------------------------------------------------------------------------------------------------------------
	
	ShowHideBtn = TWidget:CreateNewObject( "ShowHideBtn" )
	ShowHideBtn:MakeMovable( true, 687 )
	
	MainPanel = TWidget:CreateNewObject( "MainPanel" )
	MainPanel:MakeMovable( true, 686 )
	
	SpellsPanel = TWidget:CreateNewObject( "SpellInfoPanel" )
	SpellsPanel:MakeMovable( true, 688 )
	SpellsPanel:Hide()
	
	FightPanel = MainPanel:GetChildByName( "FightPanel" )
	
	---------------------------------------------------------------------------------------------------------------------------
	
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewName",  true ):SetVal( "Name", GetTextLocalized( "Type" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewStats", true ):SetVal( "Min",  GetTextLocalized( "Min" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewStats", true ):SetVal( "Mid",  GetTextLocalized( "Avg" ) )
	SpellsPanel.Widget:GetChildChecked( "SpellDetailHeaderTextViewStats", true ):SetVal( "Max",  GetTextLocalized( "Max" ) )
	
	---------------------------------------------------------------------------------------------------------------------------
	
	PlayerPanelPrototype = MainPanel:GetChildByName( "PlayerInfoPanel" )
	PlayerPanelPrototype:Hide()
	
	SpellPanelPrototype = SpellsPanel:GetChildByName( "SpellPanel" )
	SpellPanelPrototype:Hide()
	
	SpellInfoPanelPrototype = SpellsPanel:GetChildByName( "SpellDetailPanel" )
	SpellInfoPanelPrototype:Hide()
	
	---------------------------------------------------------------------------------------------------------------------------
	
	for i = 0, MAXCOMBATANTS do
		local wtName = "PlayerPanel" .. i
		PlayerPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, PlayerPanelPrototype:GetDesc(), MainPanel )
		PlayerPanelList[ i ]:SetPosition( 20, 47 + i * 24 )
	end
	
	for i = 0, 12 do
		local wtName = "SpellPanel" .. i
		SpellPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, SpellPanelPrototype:GetDesc(), SpellsPanel )
		SpellPanelList[ i ]:SetPosition( 22, 40 + i * 19 )
	end	
	
	for i = 0, 3 do
		local wtName = "SpellInfoPanel" .. i
		SpellInfoPanelList[ i ] = TWidget:CreateNewObjectByDesc( wtName, SpellInfoPanelPrototype:GetDesc(), SpellsPanel )
		SpellInfoPanelList[ i ]:SetPosition( 22, 318 + i * 15 )
	end	
	
	---------------------------------------------------------------------------------------------------------------------------
	
	DPSMeter = TDPSMeter:CreateNewObject()
	DPSMeter:AddNewFight( "AllFights" )
	DPSMeter:AddNewFight( "CurrentFight" )
	DPSMeter.ResetFightName = "CurrentFight"
	
	ActiveFightName = "CurrentFight"
	
	local NameTextView = FightPanel:GetChildByName( "FightNameTextView" )
	local Name = GetTextLocalized( ActiveFightName )
	NameTextView.Widget:SetVal( "Name", Name )
	
	if avatar.IsExist() then
		onEvent["EVENT_AVATAR_CREATED"]()
	end
end
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Init()
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
