---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global("ClassColors", {
	 ["WARRIOR"]	= { r = 0.78; g = 0.61; b = 0.43; a = 1.0 },
	 ["PALADIN"]	= { r = 0.96; g = 0.55; b = 0.73; a = 1.0 },
	 ["MAGE"]		= { r = 0.41; g = 0.8; b = 0.94; a = 1.0 },
	 ["DRUID"]		= { r = 1.0; g = 0.49; b = 0.04; a = 1.0 },
	 ["PSIONIC"]	= { r = 1.0; g = 0.96; b = 0.41; a = 1.0 },
	 ["STALKER"]	= { r = 0.67; g = 0.83; b = 0.45; a = 1.0 },
	 ["PRIEST"]		= { r = 1.0; g = 1.0; b = 1.0; a = 1.0 },
	 ["NECROMANCER"]= { r = 0.58; g = 0.51; b = 0.79; a = 1.0 }
})
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global("DamageTypeColors", {
	 ["ENUM_SubElement_PHYSICAL"]	= { r = 0.6; g = 0.4; b = 0.2; a = 1.0 },
	 ["ENUM_SubElement_FIRE"]		= { r = 1.0; g = 0.0; b = 0.0; a = 1.0 },
	 ["ENUM_SubElement_COLD"]		= { r = 0.5; g = 0.5; b = 1.0; a = 1.0 },
	 ["ENUM_SubElement_LIGHTNING"]	= { r = 0.8; g = 0.8; b = 1.0; a = 1.0 },
	 ["ENUM_SubElement_HOLY"]		= { r = 1.0; g = 1.0; b = 0.5; a = 1.0 },
	 ["ENUM_SubElement_SHADOW"]		= { r = 0.5; g = 0.1; b = 0.7; a = 1.0 },
	 ["ENUM_SubElement_ASTRAL"]		= { r = 1.0; g = 1.0; b = 1.0; a = 1.0 },
	 ["ENUM_SubElement_POISON"]		= { r = 0.5; g = 1.0; b = 0.5; a = 1.0 },
	 ["ENUM_SubElement_DISEASE"]	= { r = 0.7; g = 0.7; b = 0.4; a = 1.0 },
	 ["ENUM_SubElement_ACID"]		= { r = 1.0; g = 1.0; b = 0.0; a = 1.0 }
})
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global("HitTypeColors", {
	 ["HIT"]   = { r = 1.0; g = 1.0; b = 1.0; a = 1.0 },
	 ["CRIT"]  = { r = 1.0; g = 0.0; b = 0.0; a = 1.0 },
	 ["MISS"]  = { r = 1.0; g = 0.96; b = 0.41; a = 1.0 },
	 ["DODGE"] = { r = 0.0; g = 0.0; b = 1.0; a = 1.0 },
	 ["GLANCING"] = { r = 0.5; g = 1.0; b = 0.5; a = 1.0 }
})
---------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------       -----------------------------------
---------------------------------------------------------------------------------------------------------------------------
-- Hack for AO 1.1.00 / 1.1.01 by SLA
if common.GetGlobalConfigSection then
	if not avatar.GetEmotes then Global( "userMods", {} ) end
	userMods.GetGlobalConfigSection = common.GetGlobalConfigSection
	userMods.SetGlobalConfigSection = common.SetGlobalConfigSection
end
---------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------  "" -------------------------------------------
---------------------------------------------------------------------------------------------------------------------------
function CloneTable( value )
	if type( value ) == "table" then
		local new = {}
		for id, val in value do
			new[ id ] = CloneTable( val )
		end
		return new
	else
		return value
	end
end
--------------------------------------------------------------------------------
function PrintData( data, tabstep )
	if data == nil then
		LogInfo( "nil (no table)" )
		return
	end
	assert( type( data ) == "table", "Invalid data passed" )
	local TabString = string.rep( "\t", tabstep or 0 )
	local isEmpty = true
	for i, dataValue in data do
		if type( dataValue ) == "table" then
			LogInfo( TabString, i, ":" )
			PrintData( dataValue, tabstep + 1 )
		else
			LogInfo( TabString, i, " = ", dataValue )
		end
		isEmpty = false
	end
	if isEmpty then
		LogInfo( TabString, "{} (empty table)" )
	end
end
--------------------------------------------------------------------------------
function RegisterEventHandlers( handlers )
	for event, handler in handlers do
		common.RegisterEventHandler( handler, event )
	end
end
--------------------------------------------------------------------------------
function RegisterReactionHandlers( handlers )
	for event, handler in handlers do
		common.RegisterReactionHandler( handler, event )
	end
end
--------------------------------------------------------------------------------
-- Localization selection by SLA. Version 2010-07-31.
function GetGameLocalization()
	local L = cartographer.GetMapBlockInfo( cartographer.GetMapBlocks()[4] ).name
	if     common.CompareWString( L, common.GetAddonRelatedText( "localization_rus" ) ) == 0 then return "rus"
	elseif common.CompareWString( L, common.GetAddonRelatedText( "localization_eng" ) ) == 0 then return "eng"
	elseif common.CompareWString( L, common.GetAddonRelatedText( "localization_ger" ) ) == 0 then return "ger"
	elseif common.CompareWString( L, common.GetAddonRelatedText( "localization_fra" ) ) == 0 then return "fra"
	end
	return "eng"
end
--------------------------------------------------------------------------------
function GetTextLocalized( strTextName )
	return common.GetAddonRelatedText( string.format( "%s_%s", localization, strTextName ) )
end
--------------------------------------------------------------------------------
function SetConfig( name, value )
	local cfg = userMods.GetGlobalConfigSection( common.GetAddonName() ) or {}
	if type( name ) == "table" then
		for i, v in pairs( name ) do cfg[ i ] = v end
	elseif name ~= nil then
		cfg[ name ] = value
	end
	userMods.SetGlobalConfigSection( common.GetAddonName(), cfg )
end
--------------------------------------------------------------------------------
function GetConfig( name )
	local cfg = userMods.GetGlobalConfigSection( common.GetAddonName() )
	return cfg and cfg[ name ]
end
--------------------------------------------------------------------------------
function DNDInit()
	Global( "DragNDropWidgetList", {} )
	Global( "ScreenInfo", {} )
	ScreenInfo = widgetsSystem:GetPosConverterParams()
	common.RegisterEventHandler( OnEventDNDPickAttempt, "EVENT_DND_PICK_ATTEMPT" )
	common.RegisterEventHandler( OnEventDNDDragTo, "EVENT_DND_DRAG_TO" )
	common.RegisterEventHandler( OnEventDNDDropAttempt, "EVENT_DND_DROP_ATTEMPT" )
end
--------------------------------------------------------------------------------
function DNDReg( wtWidget, wtID )
	if DragNDropWidgetList[ wtID ] == nil then 
		local NewDNDWidgetInfo = {
			Widget = wtWidget,
			ID = wtID,
			IsPicked = false
		}
		local CfgX = GetConfig( "w" .. tostring(NewDNDWidgetInfo.ID) .. "x" )
		local CfgY = GetConfig( "w" .. tostring(NewDNDWidgetInfo.ID) .. "y" )
		if CfgX and CfgY then
			local NewPlacement = NewDNDWidgetInfo.Widget:GetPlacementPlain()
			
			local Screen = widgetsSystem:GetPosConverterParams()
			if (CfgX < 0) then CfgX = 0 end
			if (CfgX + NewPlacement.sizeX > Screen.fullVirtualSizeX) then CfgX = math.floor( Screen.fullVirtualSizeX - NewPlacement.sizeX ) end
			if (CfgY < 0) then CfgY = 0 end
			if (CfgY + NewPlacement.sizeY > Screen.fullVirtualSizeY) then CfgY = math.floor( Screen.fullVirtualSizeY - NewPlacement.sizeY ) end
			
			NewPlacement.posX = CfgX
			NewPlacement.posY = CfgY
			NewDNDWidgetInfo.Widget:SetPlacementPlain( NewPlacement )
		end
		
		DragNDropWidgetList[ wtID ] = {}
		DragNDropWidgetList[ wtID ] = NewDNDWidgetInfo
	end
	mission.DNDRegister( wtWidget, DND_WIDGET_MOVE * DND_CONTAINER_STEP + wtID, true )
end
--------------------------------------------------------------------------------
function DNDUnreg( wtWidget, ID )
	mission.DNDUnregister( wtWidget )
end
--------------------------------------------------------------------------------
function OnEventDNDPickAttempt( params )
	for wtID, NewDNDWidgetInfo in DragNDropWidgetList do
		if math.mod( params.srcId, DND_CONTAINER_STEP ) == NewDNDWidgetInfo.ID then
			NewDNDWidgetInfo.Place = NewDNDWidgetInfo.Widget:GetPlacementPlain()
			ScreenInfo = widgetsSystem:GetPosConverterParams()
			NewDNDWidgetInfo.DeltaX = math.ceil( params.posX * ScreenInfo.fullVirtualSizeX / ScreenInfo.realSizeX - NewDNDWidgetInfo.Place.posX )
			NewDNDWidgetInfo.DeltaY = math.ceil( params.posY * ScreenInfo.fullVirtualSizeY / ScreenInfo.realSizeY - NewDNDWidgetInfo.Place.posY )
			common.SetCursor( "drag" )
			NewDNDWidgetInfo.IsPicked = true
		end
	end
end
--------------------------------------------------------------------------------
function OnEventDNDDragTo( params )
	for wtID, NewDNDWidgetInfo in DragNDropWidgetList do
		if NewDNDWidgetInfo.IsPicked then
			NewDNDWidgetInfo.Place.posX = math.ceil( params.posX * ScreenInfo.fullVirtualSizeX / ScreenInfo.realSizeX - NewDNDWidgetInfo.DeltaX )
			NewDNDWidgetInfo.Place.posY = math.ceil( params.posY * ScreenInfo.fullVirtualSizeY / ScreenInfo.realSizeY - NewDNDWidgetInfo.DeltaY )
			NewDNDWidgetInfo.Widget:SetPlacementPlain( NewDNDWidgetInfo.Place )
			common.SetCursor( "drag" )
		end
	end
end
--------------------------------------------------------------------------------
function OnEventDNDDropAttempt( params )
	for wtID, NewDNDWidgetInfo in DragNDropWidgetList do
		if NewDNDWidgetInfo.IsPicked then
			mission.DNDConfirmDropAttempt()
			common.SetCursor( "default" )
			NewDNDWidgetInfo.IsPicked = false
			local NameX = "w" .. tostring(NewDNDWidgetInfo.ID) .. "x"
			local NameY = "w" .. tostring(NewDNDWidgetInfo.ID) .. "y"
			SetConfig( { [ NameX ] = NewDNDWidgetInfo.Place.posX, [ NameY ] = NewDNDWidgetInfo.Place.posY } )
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------   ,  --------------------------------------
---------------------------------------------------------------------------------------------------------------------------
Global( "TWidget", {} )
---------------------------------------------------------------------------------------------------------------------------
function TWidget:CreateNewObject( WidgetName )
	return setmetatable( {
			Widget = WidgetName and mainForm:GetChildUnchecked( WidgetName, true ),
			bMovable = false,
			DNDID = -1
		}, { __index = self } )
end
--------------------------------------------------------------------------------
function TWidget:CreateNewObjectByDesc( WidgetName, Desc, Parent )
	local Widget = mainForm:CreateWidgetByDesc( Desc )
	Widget:SetName( WidgetName )

	if Parent then
		Parent.Widget:AddChild( Widget )
	end

	return setmetatable( { Widget = Widget }, { __index = self } )
end
--------------------------------------------------------------------------------
function TWidget:GetDesc()
	if self.Widget then 
		return self.Widget:GetWidgetDesc()
	end
end
--------------------------------------------------------------------------------
function TWidget:GetChildCount()
	if self.Widget then 
		return table.getn( self.Widget:GetNamedChildren() ) + 1
	end
	return 0
end
--------------------------------------------------------------------------------
function TWidget:GetChildByName( Name )
	if self.Widget then 
		local wtChild = self.Widget:GetChildUnchecked( Name, false )
		
		if wtChild then
			return setmetatable( { Widget = wtChild }, { __index = self } )
		end
	end
end
--------------------------------------------------------------------------------
function TWidget:GetChildByIndex( Index )
	if self.Widget then 
		local wtChildren = self.Widget:GetNamedChildren()
		local wtChild = wtChildren[ Index ]
		
		if wtChild then
			return setmetatable( { Widget = wtChild }, { __index = self } )
		end
	end
end
--------------------------------------------------------------------------------
function TWidget:MakeMovable( bMovable, ID )
	if self.Widget then
		self.bMovable = bMovable
		self.DNDID = bMovable and ID or -1
			
		if bMovable then
			DNDReg( self.Widget, ID )
		else
			DNDUnreg( self.Widget, ID )
		end
	end
end
--------------------------------------------------------------------------------
function TWidget:SetPosition( newX, newY )
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		Placement.posX = math.ceil( newX )
		Placement.posY = math.ceil( newY )
		self.Widget:SetPlacementPlain( Placement )
	end
end
--------------------------------------------------------------------------------
function TWidget:SetWidth( newW )
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		Placement.sizeX =  math.ceil( newW )
		self.Widget:SetPlacementPlain( Placement )
	end
end
--------------------------------------------------------------------------------
function TWidget:SetHeight( newH )
	if self.Widget then 
		local Placement = self.Widget:GetPlacementPlain()
		Placement.sizeY = math.ceil( newH )
		self.Widget:SetPlacementPlain( Placement )
	end
end
--------------------------------------------------------------------------------
function TWidget:GetWidth()
	if self.Widget then 
		return self.Widget:GetPlacementPlain().sizeX
	end
end
--------------------------------------------------------------------------------
function TWidget:GetHeight()
	if self.Widget then 
		return self.Widget:GetPlacementPlain().sizeY
	end
end
--------------------------------------------------------------------------------
function TWidget:SetColor( Color )
	if self.Widget then 
		self.Widget:SetBackgroundColor( Color )
	end
end
--------------------------------------------------------------------------------
function TWidget:Show()
	if self.Widget then 
		self.Widget:Show(true)
		if self.bMovable then 
			DNDReg( self.Widget, self.DNDID )
		end
	end
end
--------------------------------------------------------------------------------
function TWidget:Hide()
	if self.Widget then 
		self.Widget:Show(false)
		if self.bMovable then 
			DNDUnreg( self.Widget, self.DNDID )
		end
	end
end
--------------------------------------------------------------------------------
function TWidget:HideAllChild()
	if self.Widget then
		local wtChildren = self.Widget:GetNamedChildren()
		for _, wtChild in pairs( wtChildren ) do
			wtChild:Show( false )
		end
	end
end
--------------------------------------------------------------------------------
function TWidget:ShowAllChild()
	if self.Widget then
		local wtChildren = self.Widget:GetNamedChildren()
		for _, wtChild in pairs( wtChildren ) do
			wtChild:Show( true )
		end
	end
end
---------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------    --------------------------------------
---------------------------------------------------------------------------------------------------------------------------




